<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace IAWPSCOPED\Carbon\Exceptions;

use InvalidArgumentException as BaseInvalidArgumentException;
use Throwable;
/** @internal */
class UnknownSetterException extends BaseInvalidArgumentException implements BadMethodCallException
{
    /**
     * The setter.
     *
     * @var string
     */
    protected $setter;
    /**
     * Constructor.
     *
     * @param string         $setter   setter name
     * @param int            $code
     * @param Throwable|null $previous
     */
    public function __construct($setter, $code = 0, Throwable $previous = null)
    {
        $this->setter = $setter;
        parent::__construct("Unknown setter '{$setter}'", $code, $previous);
    }
    /**
     * Get the setter.
     *
     * @return string
     */
    public function getSetter() : string
    {
        return $this->setter;
    }
}
